#include <cvidef.h>

/*= <mxOX9000> Include File ===================================================*/
 
/*===========================================================================*/
/*  Please do not use global variables or arrays in the include file of      */
/*  instrument drivers that will be submitted for inclusion into the         */
/*  LabWindows Instrument Driver Library.                                    */
/*===========================================================================*/
     
#ifndef __mxOX9000_HEADER
#define __mxOX9000_HEADER

#include <vpptype.h>

#if defined(__cplusplus) || defined(__cplusplus__)
extern "C" {
#endif

#define VI_ERROR_INSTR_FILE_OPEN                (_VI_ERROR+0x3FFC0800L)
#define VI_ERROR_INSTR_FILE_WRITE               (_VI_ERROR+0x3FFC0801L)
#define VI_ERROR_INSTR_INTERPRETING_RESPONSE    (_VI_ERROR+0x3FFC0803L)
#define VI_ERROR_INSTR_PARAMETER9               (_VI_ERROR+0x3FFC0809L)
#define VI_ERROR_INSTR_PARAMETER10              (_VI_ERROR+0x3FFC080AL)
#define VI_ERROR_INSTR_PARAMETER11              (_VI_ERROR+0x3FFC080BL)
#define VI_ERROR_INSTR_PARAMETER12              (_VI_ERROR+0x3FFC080CL)
#define VI_ERROR_INSTR_PARAMETER13              (_VI_ERROR+0x3FFC080DL)
#define VI_ERROR_INSTR_PARAMETER14              (_VI_ERROR+0x3FFC080EL)
#define VI_ERROR_INSTR_PARAMETER15              (_VI_ERROR+0x3FFC080FL)

/*****************************************************************************/
/*= Define Instrument Specific Error/Warning Codes Here =====================*/
/*****************************************************************************/
#define VI_WARNING_INSTR_OFFSET                           (0x3FFC0900L)
#define VI_ERROR_INSTR_OFFSET                   (_VI_ERROR+0x3FFC0900L)

#define PREFIX_ERROR_INVALID_CONFIGURATION      (VI_ERROR_INSTR_OFFSET + 0xF0L)


/*****************************************************************************/
/*= Define Instrument Specific Error Codes Here =============================*/
/*****************************************************************************/
#define VI_ERROR_PARAMETER9             (_VI_ERROR+0x3FFC0009L)


#define VI_ERROR_mxOX9000_ERROR                   (_VI_ERROR+0x3FFC0900L)
#define VI_ERROR_mxOX9000_INCONSISTENT_PARAMETER3 (_VI_ERROR+0x3FFC0903L)
#define VI_ERROR_mxOX9000_INCONSISTENT_PARAMETER5 (_VI_ERROR+0x3FFC0905L)
#define VI_ERROR_mxOX9000_INCONSISTENT_PARAMETER6 (_VI_ERROR+0x3FFC0906L)
#define VI_ERROR_mxOX9000_INCONSISTENT_PARAMETER7 (_VI_ERROR+0x3FFC0907L)
#define VI_ERROR_mxOX9000_AUTOTEST_PROBLEM        (_VI_ERROR+0x3FFC090BL)
#define VI_ERROR_mxOX9000_CHAN_NOT_ACTIVE         (_VI_ERROR+0x3FFC090CL)
#define VI_ERROR_mxOX9000_FILE_NOT_FOUND          (_VI_ERROR+0x3FFC090DL)
#define VI_ERROR_mxOX9000_EXISTING_FILE           (_VI_ERROR+0x3FFC090EL)
#define VI_ERROR_mxOX9000_NO_CHAN_ENABLED         (_VI_ERROR+0x3FFC090FL)
#define VI_ERROR_mxOX9000_INVALID_FILE_CONTENT    (_VI_ERROR+0x3FFC0910L)

/*****************************************************************************/
/*= GLOBAL USER-CALLABLE FUNCTION DECLARATIONS (Exportable Functions) =======*/
/*****************************************************************************/
ViStatus _VI_FUNC mxOX9000_init (ViRsrc resourceName, ViBoolean IDQuery, ViPSession instrumentHandle);
ViStatus _VI_FUNC mxOX9000_example (ViSession instrumentHandle, ViInt16 source, ViInt16 timebaseA, ViInt16 voltageRange,
						ViInt16 coupling, ViReal64 _VI_FAR waveformArray[], ViPInt32 numberofsamples, ViPReal64 XStart, ViPReal64 XIncrement);
ViStatus _VI_FUNC mxOX9000_verticalSetup (ViSession instrumentHandle, ViInt16 input, ViBoolean state, ViInt16 coupling, 
						ViInt16 probe, ViInt16 voltDiv, ViReal64 offsetvolts, ViInt16 bandwidth);
ViStatus _VI_FUNC mxOX9000_horizontalSetup (ViSession instrumentHandle, ViInt16 range, ViReal64 runafterdelays);
ViStatus _VI_FUNC mxOX9000_horizontalDisplay (ViSession instrumentHandle, ViInt16 trace, ViInt16 x, ViInt16 y);
ViStatus _VI_FUNC mxOX9000_FFT (ViSession instrumentHandle, ViBoolean ffton_off, ViInt16 calculate, ViBoolean scalelog_linear);
ViStatus _VI_FUNC mxOX9000_setGeneralTrigger (ViSession instrumentHandle, ViInt16 triggerSource, ViBoolean slope, ViInt16 coupling,
						ViInt16 noiseRejection, ViInt16 Type, ViReal64 levelvolts, ViReal64 holdoff);
ViStatus _VI_FUNC mxOX9000_setPulsTrigger (ViSession instrSession, ViInt16 pulsType, ViReal64 T1, ViReal64 T2);
ViStatus _VI_FUNC mxOX9000_setDelayedTrigger (ViSession instrSession, ViInt16 auxi_source, ViBoolean edge,
						ViInt16 coupling, ViInt16 noiseReject, ViReal64 level, ViReal64 delay);
ViStatus _VI_FUNC mxOX9000_setCountTrigger (ViSession instrSession, ViInt16 auxi_source,
                   		ViBoolean edge, ViInt16 coupling, ViInt16 noiseReject, ViReal64 level, ViInt32 events);
ViStatus _VI_FUNC mxOX9000_setOptionDisplay (ViSession instrumentHandle, ViInt16 device);
ViStatus _VI_FUNC mxOX9000_setWaveformDisplay (ViSession instrumentHandle, ViInt16 acquisition,
						ViInt16 averagerate, ViInt16 displaymode, ViBoolean repetitive);
ViStatus _VI_FUNC mxOX9000_setCursors (ViSession instrumentHandle, ViInt16 cursors, ViInt16 reference, ViReal64 t1s, 
						ViReal64 t2s, ViReal64 tphases);
ViStatus _VI_FUNC mxOX9000_runAutoset (ViSession instrumentHandle);
ViStatus _VI_FUNC mxOX9000_runAcquisition (ViSession instrumentHandle, ViBoolean Run);
ViStatus _VI_FUNC mxOX9000_runHardcopy (ViSession instrumentHandle);
ViStatus _VI_FUNC mxOX9000_readCursors (ViSession instrumentHandle, ViInt16 reference, ViPReal64 t1s,
						ViPReal64 t2s, ViPReal64 dTs, ViPReal64 tphase, ViPReal64 v1v, ViPReal64 v2v, ViPReal64 dVv);
ViStatus _VI_FUNC mxOX9000_readMeasurement (ViSession instrumentHandle, ViInt16 measurement, ViInt16 reference, ViPReal64 reading);
ViStatus _VI_FUNC mxOX9000_readChToArr (ViSession instrumentHandle, ViInt16 source, ViReal64 _VI_FAR waveformArray[],
                   		ViPInt32 numberofsamples, ViPReal64 XStart, ViPReal64 XIncrement ); 
ViStatus _VI_FUNC mxOX9000_readChToFile (ViSession instrumentHandle, ViInt16 source,
                   		ViInt16 drives, ViString fileName, ViBoolean overwriteFile);
ViStatus _VI_FUNC mxOX9000_writeFileToMem (ViSession instrumentHandle, ViString fileName);
ViStatus _VI_FUNC mxOX9000_saveSetup (ViSession instrumentHandle, ViBoolean mode, ViInt16 drives, ViString fileName, ViBoolean overwriteFile);
ViStatus _VI_FUNC mxOX9000_fileTransfer (ViSession instrumentHandle, ViString fileName, ViInt16 sourceDrive, ViBoolean overwriteFile);
ViStatus _VI_FUNC mxOX9000_writeInstrData (ViSession instrumentHandle, ViString writeBuffer);
ViStatus _VI_FUNC mxOX9000_readInstrData (ViSession instrumentHandle, ViInt32 numberBytesToRead, ViChar _VI_FAR readBuffer[], ViPInt32 numBytesRead);
ViStatus _VI_FUNC mxOX9000_reset (ViSession instrumentHandle);
ViStatus _VI_FUNC mxOX9000_selfTest (ViSession instrumentHandle, ViPInt16 selfTestResult, ViChar _VI_FAR selfTestMessage[]);
ViStatus _VI_FUNC mxOX9000_errorQuery (ViSession instrumentHandle, ViPInt32 errorCode, ViChar _VI_FAR errorMessage[]);
ViStatus _VI_FUNC mxOX9000_errorMessage (ViSession instrumentHandle, ViStatus errorCode, ViChar _VI_FAR errorMessage[]);
ViStatus _VI_FUNC mxOX9000_revisionQuery (ViSession instrumentHandle, ViChar _VI_FAR instrumentDriverRevision[], ViChar _VI_FAR firmwareRevision[]);
ViStatus _VI_FUNC mxOX9000_Meterconfig (ViSession instrumentHandle, ViInt16 Input, ViInt16 Measure, ViInt16 Coupling, 
						ViInt16 bandwith, ViBoolean AutoRange, ViInt16 VoltRang, ViInt16 OhmRang, ViInt16 CapaRang);
ViStatus _VI_FUNC mxOX9000_readMeterMeas (ViSession instrumentHandle, ViInt16 Reference, ViPReal64 Reading);
ViStatus _VI_FUNC mxOX9000_close (ViSession instrumentHandle);


#if defined(__cplusplus) || defined(__cplusplus__)
}
#endif

/*****************************************************************************/
/*=== END INCLUDE FILE ======================================================*/
/*****************************************************************************/

#endif
